<x-kasir.contents>
    <x-slot:title>{{ $data['title'] }}</x-slot:title>
    <x-slot:menuActive>{{ $data['menuActive'] }} </x-slot:menuActive>
    <x-slot:head>
        <link rel="stylesheet" href="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.min.css">
        <link rel="stylesheet" href="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.css">
    </x-slot:head>


    <div class="content-wrapper">
        <!-- Content Header (Page header) -->
        <div class="content-header">
            <div class="container-fluid">

            </div><!-- /.container-fluid -->
        </div>

        <div class="content">
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-8">
                        <div class="card card-danger card-outline">
                            <div class="overlay bg-white " style="opacity: 0.5">
                                <i class="fas fa-3x fa-spinner fa-pulse"></i>
                            </div>
                            <div class="card-header">
                                <button class="btn btn-dark  float-right cetak"><i class="fa fa-print mr-2"></i>
                                    Cetak</button>
                                <h3 class="card-title"><i class="fa fa-server text-danger"></i> Data {{ $data['page'] }}
                                </h3>
                            </div>
                            <div class="card-body">
                                <div id="hidedata">
                                    <div id="print">
                                        <div class="tampil_data"></div>
                                    </div>
                                </div>
                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->
                    <div class="col-lg-4">
                        <div class="card card-danger card-outline">
                            <div class="card-header">
                                <h3 class="card-title"><i class="fa fa-database text-danger"></i> Cari
                                    {{ $data['page'] }}
                                </h3>
                            </div>
                            <div class="card-body">
                                <label for="">Pilih Tanggal</label>
                                <input type="date" name="" id="tgl" class="form-control"
                                    value="{{ date('Y-m-d') }}">
                                <br>

                                <div class="row">
                                    <div class="col-md-6">
                                        <label for="">Dari Jam</label>
                                        <select name="" id="jam1" class="form-control">
                                            <option value="">Pilih</option>
                                            @for ($x = 01; $x <= 24; $x++)
                                                <option value="{{ $x < 10 ? '0' : '' }}{{ $x }}:00:00">
                                                    Pukul {{ $x < 10 ? '0' : '' }}{{ $x }}
                                                    : 00
                                                </option>
                                            @endfor
                                        </select>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="">Sampai Jam</label>
                                        <select name="" id="jam2" class="form-control">
                                            <option value="">Pilih</option>
                                            @for ($x = 01; $x <= 24; $x++)
                                                <option value="{{ $x < 10 ? '0' : '' }}{{ $x }}:00:00">
                                                    Pukul {{ $x < 10 ? '0' : '' }}{{ $x }}
                                                    : 00
                                                </option>
                                            @endfor
                                        </select>
                                    </div>
                                </div>
                                <br>
                                <button class="btn btn-primary caridata btn-lg btn-block"><i
                                        class="fa fa-search mr-2"></i> Cek
                                    Laporan</button>

                            </div>
                        </div><!-- /.card -->
                    </div>
                    <!-- /.col-md-6 -->






                </div>
                <!-- /.row -->
            </div><!-- /.container-fluid -->
        </div>
    </div>
    <!-- /.content -->

    <x-slot:foot>
        <script src="{{ asset('assets/') }}/admin/plugins/sweetalert2/sweetalert2.all.min.js"></script>
        <script src="{{ asset('') }}assets/admin/plugins/toastr/toastr.min.js"></script>
        <script>
            $(".overlay").hide();
            $('.caridata').click(function() {
                var token = $("meta[name='csrf-token']").attr("content");
                var tgl = $('#tgl').val();
                var jam1 = $('#jam1').val();
                var jam2 = $('#jam2').val();
                if (jam1 == "") {
                    Toast.fire({
                        icon: "error",
                        title: "Pilih Mulai Jam berapa!.",
                    });
                } else if (jam2 == "") {
                    Toast.fire({
                        icon: "error",
                        title: "Pilih Sampai Jam berapa!.",
                    });
                } else {
                    $(".overlay").show();
                    $.ajax({
                        type: 'POST',
                        url: 'cek-invoice',
                        data: {
                            tgl: tgl,
                            jam1: jam1,
                            jam2: jam2,
                            _token: token,
                        },
                        success: function(data) {
                            $(".overlay").hide();
                            $('.tampil_data').html(data);
                        }
                    });
                }
            });

            $('.cetak').click(function() {
                $("#hidedata").hide();
                printPageArea("print");
                document.location.href = "";
            })

            function printPageArea(areaID) {
                var printContent = document.getElementById(areaID).innerHTML;
                var originalContent = document.body.innerHTML;
                document.body.innerHTML = printContent;
                window.print();
                document.body.innerHTML = originalContent;
            }
        </script>
    </x-slot:foot>
</x-kasir.contents>
